﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using ext = Ext.Net;
using IQFormsScripts;
using Newtonsoft;
using Newtonsoft.Json;
using Newtonsoft.Json.Schema;
using Newtonsoft.Json.Linq;


[ext.DirectMethodProxyID(Alias = "INSTRUMENTS")]

public partial class my_instruments : System.Web.UI.Page
{
    protected CQuestionnaire m_Questionnaire { get; set; }

    /// <summary>
    /// Page initialization
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Init(object sender, EventArgs e)
    {
        //register questionnaire resources
        ClientScriptManager csm = Page.ClientScript;
        QuestionnaireHelper.IncludeJavaScript(csm, "IQFormsScripts.JavaScript.questions.js");

        m_Questionnaire = new CQuestionnaire(Master.DBConn, Page);

        //pass on the BaseMaster to the Instruments List user control
        ucInstrumentList.BaseMstr = Master;
    }

    /// <summary>
    /// Page Load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) {
            if (!ext.X.IsAjaxRequest) {
                ucInstrumentList.InitializeControl();
            }
        }
    }

    [ext.DirectMethod(ShowMask = true, Msg = "Please wait")]
    /// <summary>
    /// Handles the series of events after an instrument is selected
    /// </summary>
    /// <param name="record"></param>
    public void OnSelectInstrument(object record)
    {
        dynamic d = record;

        //gets the questionnaire HTML string to be rendered on screen
        string strQuestionnaireHTML = "<div id=\"divQuestions\">" + m_Questionnaire.GetQuestionnaireHTML((long)d.mid) + "</div>";
        pnlInstrumentContainer.Update(strQuestionnaireHTML, true);

        //get instrument status
        int iStatus = (int)d.status;

        //load the instrument report 
        pnlInstrumentReport.ClearContent();
        if (iStatus == 1)
        {
            var responses = this.GetInstrumentResponsesJSON((string)d.patient_id, (long)d.mid, (long)d.intake_id);
            pnlInstrumentReport.Update(responses);
        }
    }

    [ext.DirectMethod(ShowMask = true, Msg = "Please wait")]
    /// <summary>
    /// Returns a JSON object of the instrument's responses
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <param name="lMID"></param>
    /// <param name="lIntakeID"></param>
    /// <returns></returns>
    public object GetInstrumentResponsesJSON(string strPatientID, long lMID, long lIntakeID) {
        CInstrumentResponse resp = new CInstrumentResponse(Master);
        var responses = resp.GetInstrumentResponsesJSON(strPatientID, lMID, lIntakeID);
        return responses;
    }

    [ext.DirectMethod(ShowMask = true, Msg = "Please wait", SuccessFn = "fnSuccessAddResponses", FailureFn = "fnFailureAddResponses")]
    /// <summary>
    /// submits instrument responses to the db
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public object SubmitInstrumentResponses() {
        
        bool bResult = true;

        var objInstrumentData = JsonConvert.DeserializeObject(htxtInstrumentData.Value.ToString());
        dynamic d = objInstrumentData;

        //gets the collection of responses
        DataSet dsReponses = m_Questionnaire.GetResponses();
        bResult = !(dsReponses == null);

        long lMID = d.mid;
        long lIntakeID = 0;
        long lPatPWID = d.pat_pw_id;
        long lPatPWEvtID = d.pat_pw_event_id;
        long lPwEvtModID = d.pw_event_module_id;

        CInstrumentResponse InstrumentResponse = new CInstrumentResponse(Master);

        // transform dataset into a list of <IntakeResponses>
        if (dsReponses != null) {
            List<IntakeResponse> lstResponses = JsonConvert.DeserializeObject<List<IntakeResponse>>(JsonConvert.SerializeObject(dsReponses.Tables[0]));

            //iterate the list for saving responses individually
            foreach (IntakeResponse resp in lstResponses) {

                lMID = resp.MID;
                lIntakeID = resp.Intake_ID;

                if (!InstrumentResponse.InsertInstrumentResponse(Master.SelectedPatientID,
                                            resp.Intake_ID,
                                            resp.MID,
                                            resp.TID,
                                            resp.QID,
                                            resp.RID,
                                            resp.Score_Value,
                                            resp.Response_Value))
                {
                    bResult = false;
                } 
            }
        }

        // ------------------------------------------------------------------------
        // mark module as completed 
        CIntake intake = new CIntake(Master);
        intake.CompleteModule(Master.SelectedPatientID, lMID, 1, lIntakeID);

        //proceed to the scoring
        CCPA ccpa = new CCPA();
        if (bResult)
        {
            bResult = ccpa.UpdatePatPWEventModule(Master,
                                                    Master.SelectedPatientID,
                                                    lPatPWID,
                                                    lPatPWEvtID,
                                                    lMID,
                                                    lIntakeID,
                                                    lPwEvtModID); 
        }

        // ------------------------------------------------------------------------
        // get logic from the intake_module table.  If logic exist, then process
        #region Scoring

        bool bScoreLogicError = false;
        string strRetLogicError = String.Empty;
        string strScoreErr = String.Empty;

        if (bResult)
        {
            string strInstrumentScoreLogic = InstrumentResponse.GetScoreLogic(lMID);

            CIQEngine iqe = new CIQEngine(Master);

            if (!String.IsNullOrEmpty(strInstrumentScoreLogic))
            {

                // ------------------------------------------------------------------------
                // instantiate the COM component which will perform the logic calculations


                bool bIQError = false;
                if (iqe == null)
                {
                    bIQError = true;
                }

                // ------------------------------------------------------------------------
                // get and load logic vars and send to the COM component

                DataSet dsLV = InstrumentResponse.GetIntakeLogicVarDS(Master.SelectedPatientID, lMID);
                if (bIQError == false)
                {
                    iqe.AddSQLVarItem(dsLV);
                }

                // ------------------------------------------------------------------------
                // get and load the responses dataset to the COM component

                //DataSet dsResp = InstrumentResponse.ConvertResponsesToDataSet(responses);
                DataSet dsResp = InstrumentResponse.GetMergedInstrumentResponsesDS(Master.SelectedPatientID, lMID, lIntakeID);
                if (bIQError == false)
                {
                    iqe.AddResponseVarItem(dsResp);
                }

                // ------------------------------------------------------------------------
                // send module logic to the COM component
                if (bIQError == false)
                {
                    if (iqe.Calculate(strInstrumentScoreLogic) == false)
                    {
                        bScoreLogicError = true;
                        strRetLogicError = iqe.m_strErrorMessage;
                    }

                    if (!bScoreLogicError)
                    {
                        string strJSon = "";
                        strJSon = iqe.GetJSon(iqe.nJSON_SCORE_TYPE);
                        if (strJSon.Length > 0)
                        {
                            //process JSON
                            this.InsertInstrumentScores(lMID, lIntakeID, strJSon);
                        }

                        /*
                         strJSon = iqe.GetJSon(iqe.nJSON_FLAG_TYPE);
                        if (strJSon.Length > 0)
                        {
                            //TODO - process JSON
                        }

                        strJSon = iqe.GetJSon(iqe.nJSON_PROB_TYPE);
                        if (strJSon.Length > 0)
                        {
                            //TODO - process JSON
                        }
                         */
                    }
                }
            }

            //report scoring errors
            strScoreErr = iqe.m_strErrorMessage;

        }
        #endregion

        
        return new
        {
            saved = bResult,
            patient_id = Master.SelectedPatientID,
            mid = lMID,
            intake_id = lIntakeID,
            pat_pw_id = lPatPWID,
            pat_pw_event_id = lPatPWEvtID,
            pw_event_module_id = lPwEvtModID,
            score_error = bScoreLogicError,
            score_error_msg = strScoreErr
        };
    }

    /// <summary>
    /// Insert Instrument Scores
    /// </summary>
    /// <param name="lMID"></param>
    /// <param name="lIntakeID"></param>
    /// <param name="strJsonScore"></param>
    /// <returns></returns>
    protected bool InsertInstrumentScores(long lMID, long lIntakeID, string strJsonScore)
    {

        //validate the JSON string
        string schemaJson = @"{
                                'type': 'object',
                                'properties': {
                                    'JSCORE': {
                                        'type': 'array',
                                        'required': true,
                                        'items': {
                                            'type': 'object',
                                            'properties': {
                                                'score': {
                                                    'type': 'number',
                                                    'required': true
                                                },
                                                'series': {
                                                    'type': 'number',
                                                    'required': true
                                                },
                                                'interpretation': {
                                                    'type': 'string',
                                                    'required': true
                                                },
                                                'description': {
                                                    'type': 'string',
                                                    'required': true
                                                }
                                            }
                                        }
                                    }
                                },
                                'additionalProperties': false
                            }";

        if (strJsonScore.Length > 1)
        {
            try
            {
                JsonSchema schema = JsonSchema.Parse(schemaJson);
                JObject jScore = JObject.Parse(strJsonScore);
                bool bValidJson = jScore.IsValid(schema);
                if (bValidJson)
                {
                    DataSet ds = JsonConvert.DeserializeObject<DataSet>(strJsonScore);
                    if (ds != null)
                    {
                        CInstrumentResponse instr = new CInstrumentResponse(Master);

                        //remove previous scores
                        instr.DeleteInstrumentScore(Master.SelectedPatientID, lMID, lIntakeID);

                        foreach (DataTable dt in ds.Tables)
                        {
                            foreach (DataRow dr in dt.Rows)
                            {
                                //score
                                long lScore = -1;
                                Decimal dScore = -1;

                                if (!dr.IsNull("score"))
                                {
                                    if (long.TryParse(dr["score"].ToString(), out lScore) == true)
                                    {
                                        dScore = -1;
                                    }
                                    else if (decimal.TryParse(dr["score"].ToString(), out dScore) == true)
                                    {
                                        lScore = -1;
                                    }
                                    else
                                    {
                                    }

                                }

                                //series
                                long lSeries = -1;
                                if (!dr.IsNull("series"))
                                {
                                    long.TryParse(dr["series"].ToString(), out lSeries);
                                }

                                //interpret_id
                                string strInterpret = String.Empty; ;
                                if (!dr.IsNull("Interpretation"))
                                {
                                    strInterpret = dr["Interpretation"].ToString();
                                }

                                //description
                                string strDescription = String.Empty;
                                if (dr["description"] != null)
                                {
                                    if (!dr.IsNull("description"))
                                    {
                                        strDescription = dr["description"].ToString();
                                    }
                                }

                                //Insert Score
                                if (lScore > -1)
                                {
                                    if (instr.InsertInstrumentScore(Master.SelectedPatientID, lMID, lIntakeID, lSeries, lScore, strInterpret, strDescription) == false)
                                    {
                                        return false;
                                    }
                                }
                                else if (dScore > -1)
                                {
                                    if (instr.InsertInstrumentScore(Master.SelectedPatientID, lMID, lIntakeID, lSeries, (double)dScore, strInterpret, strDescription) == false)
                                    {
                                        return false;
                                    }
                                }

                            }
                        }
                    }
                }
            }
            catch (Exception)
            {
                return false;
            }
        }

        return true;
    }

    /// <summary>
    /// Helper class for modeling the responses collection
    /// </summary>
    public class IntakeResponse
    {
        public IntakeResponse() { }
        //public string PatientID { set; get; }
        public long MID { set; get; }
        public long TID { set; get; }
        public long QID { set; get; }
        public long RID { set; get; }
        public long Intake_ID { set; get; }
        public string Identifier { set; get; }
        public long Score_Value { set; get; }
        public string Response_Value { set; get; }
        public long Response_Type { set; get; }
    }

}